/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FurnitureWaterloggedBlock;
import com.mrcrayfish.furniture.core.ModItems;
import com.mrcrayfish.furniture.item.crafting.GrillCookingRecipe;
import com.mrcrayfish.furniture.tileentity.GrillTileEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GrillBlock
extends FurnitureWaterloggedBlock
implements ISidedInventoryProvider {
    public static final VoxelShape SHAPE = VoxelShapeHelper.combineAll(Arrays.asList(Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)11.0, (double)14.5)));

    public GrillBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof GrillTileEntity) {
                GrillTileEntity grillTileEntity = (GrillTileEntity)tileEntity;
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, grillTileEntity.getGrill());
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, grillTileEntity.getFuel());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        if (!world.field_72995_K && result.func_216354_b() == Direction.UP && (tileEntity = world.func_175625_s(pos)) instanceof GrillTileEntity) {
            GrillTileEntity grillTileEntity = (GrillTileEntity)tileEntity;
            ItemStack stack = playerEntity.func_184586_b(hand);
            if (stack.func_77973_b() == ModItems.SPATULA) {
                grillTileEntity.flipItem(this.getPosition(result, pos));
            } else if (stack.func_77973_b() == Items.field_151044_h || stack.func_77973_b() == Items.field_196155_l) {
                if (grillTileEntity.addFuel(stack)) {
                    stack.func_190918_g(1);
                }
            } else if (!stack.func_190926_b()) {
                Optional<GrillCookingRecipe> optional = grillTileEntity.findMatchingRecipe(stack);
                if (optional.isPresent()) {
                    GrillCookingRecipe recipe = optional.get();
                    if (grillTileEntity.addItem(stack, this.getPosition(result, pos), recipe.func_222137_e(), recipe.func_222138_b(), (byte)playerEntity.func_174811_aO().func_176736_b()) && !playerEntity.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                }
            } else {
                grillTileEntity.removeItem(this.getPosition(result, pos));
            }
        }
        return ActionResultType.SUCCESS;
    }

    private int getPosition(BlockRayTraceResult hit, BlockPos pos) {
        Vector3d hitVec = hit.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        int position = 0;
        if (hitVec.func_82615_a() > 0.5) {
            ++position;
        }
        if (hitVec.func_82616_c() > 0.5) {
            position += 2;
        }
        return position;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new GrillTileEntity();
    }

    public ISidedInventory func_219966_a(BlockState state, IWorld world, BlockPos pos) {
        TileEntity tileEntity;
        if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof GrillTileEntity) {
            return (GrillTileEntity)tileEntity;
        }
        return null;
    }
}

